/*
 * Decompiled with CFR 0.152.
 */
package hangman;

import hangman.ServerThread;
import java.io.IOException;
import java.net.ServerSocket;
import java.util.ResourceBundle;

public class Server {
    private boolean verbose;
    private ResourceBundle resources;
    private String databaseDriver;
    private String databaseURL;
    private int port;
    private static int clientCount;

    public Server(boolean bl) {
        this.verbose = bl;
        this.resources = ResourceBundle.getBundle("hangman");
        this.databaseDriver = this.resources.getString("database.driver");
        this.databaseURL = this.resources.getString("database.url");
        this.port = Integer.parseInt(this.resources.getString("hangman.port"));
        System.out.println("Hangman Middle Tier Server, Version 1.0");
        System.out.println("Copyright (C) 2000 Ariel Ortiz");
        if (bl) {
            System.out.println("Verbose mode is ON.");
        } else {
            System.out.println("Verbose mode is OFF. Use -v option to set it ON.");
        }
        System.out.println("Endpoint created: " + this.port);
    }

    public String getDatabaseDriver() {
        return this.databaseDriver;
    }

    public String getDatabaseURL() {
        return this.databaseURL;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public static void main(String[] stringArray) {
        new Server(stringArray.length == 1 && stringArray[0].equals("-v")).start();
    }

    public void start() {
        ServerThread serverThread = null;
        try {
            ServerSocket serverSocket = new ServerSocket(this.port);
            while (true) {
                try {
                    while (true) {
                        serverThread = new ServerThread(this, ++clientCount, serverSocket.accept());
                        serverThread.start();
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    continue;
                }
                break;
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return;
        }
    }
}

