/*
 * Decompiled with CFR 0.152.
 */
package hangman;

import hangman.MysteryWord;
import hangman.Server;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.Socket;

public class ServerThread
extends Thread {
    private Server server;
    private int id;
    private Socket socket;
    private BufferedReader input;
    private PrintWriter output;

    public ServerThread(Server server, int n, Socket socket) throws IOException {
        this.id = n;
        this.socket = socket;
        this.server = server;
        this.input = new BufferedReader(new InputStreamReader(socket.getInputStream()));
        this.output = new PrintWriter(new OutputStreamWriter(socket.getOutputStream()));
    }

    public void close() {
        try {
            if (this.output != null) {
                this.output.close();
            }
            if (this.input != null) {
                this.input.close();
            }
            if (this.socket != null) {
                this.socket.close();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void run() {
        try {
            if (this.server.isVerbose()) {
                System.out.println("(" + this.id + ") connection begin");
            }
            MysteryWord mysteryWord = null;
            this.write("READY");
            while (true) {
                String string;
                try {
                    string = this.input.readLine();
                }
                catch (IOException iOException) {
                    string = null;
                }
                if (string == null || string.equals("BYE")) break;
                if (this.server.isVerbose()) {
                    System.out.println("from client (" + this.id + ")... " + string);
                }
                if (mysteryWord == null) {
                    if (string.startsWith("CHOOSE:")) {
                        mysteryWord = new MysteryWord(this.server, string.substring(string.indexOf(58) + 1));
                        this.write("OK:" + mysteryWord.getUnsolvedWord());
                        continue;
                    }
                    this.write("ERROR");
                    continue;
                }
                if (string.startsWith("CONTAINS:")) {
                    if (mysteryWord.guess(string.charAt(string.indexOf(58) + 1))) {
                        if (mysteryWord.allGuessed()) {
                            this.write("WON:" + mysteryWord.getUnsolvedWord());
                            mysteryWord = null;
                            continue;
                        }
                        this.write("YES:" + mysteryWord.getUnsolvedWord());
                        continue;
                    }
                    if (mysteryWord.opportunitiesLeft() == 0) {
                        this.write("LOST:" + mysteryWord.getWord());
                        mysteryWord = null;
                        continue;
                    }
                    this.write("NO:" + mysteryWord.opportunitiesLeft());
                    continue;
                }
                if (string.equals("GIVEUP")) {
                    this.write("LOST:" + mysteryWord.getWord());
                    mysteryWord = null;
                    continue;
                }
                this.write("ERROR");
            }
            Object var2_3 = null;
            this.close();
            if (this.server.isVerbose()) {
                System.out.println("(" + this.id + ") connection end");
            }
        }
        catch (Throwable throwable) {
            Object var2_4 = null;
            this.close();
            if (this.server.isVerbose()) {
                System.out.println("(" + this.id + ") connection end");
            }
            throw throwable;
        }
    }

    private void write(String string) {
        this.output.println(string);
        this.output.flush();
        if (this.server.isVerbose()) {
            System.out.println("to client (" + this.id + ")...   " + string);
        }
    }
}

